﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using IndianHealthService.BMXNet.Model;
using IndianHealthService.BMXNet.WinForm.Model;

namespace IndianHealthService.BMXNet.Forms
{
    internal partial class ChangeDivisionDialog : Form
    {
        public ChangeDivisionDialog()
        {
            InitializeComponent();
        }

        private void cancelButton_Click(object sender, EventArgs e)
        {

        }

        private void okButton_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private List<SelectableDivision> _divisions = new List<SelectableDivision>();

        public List<SelectableDivision> Divisions
        {
            get { return _divisions; }
            set { _divisions = value; }
        }

        private void ChangeDivisionDialog_Load(object sender, EventArgs e)
        {
            this.Icon = this.Owner.Icon;
            
            this.divisionList.BeginUpdate();
            this.divisionList.DataSource=this.Divisions;
            foreach (WinDivision each in this.Divisions) {
                if (each.MostRecentLookup)
                {
                    this.divisionList.SelectedItem = each;
                }
            }
            this.divisionList.EndUpdate();

            this.divisionList.Focus();
            this.UpdateCues();
        }

        private void divisionList_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.UpdateCues();
        }

        public void UpdateCues()
        {
            this.okButton.Enabled = this.SelectedDivision!= null;
        }

        public Division SelectedDivision
        {
            get { return (Division)this.divisionList.SelectedItem; }
        }

        private void divisionList_DoubleClick(object sender, EventArgs e)
        {
            if (this.okButton.Enabled)
            {
                this.DialogResult = DialogResult.OK;
                this.Close();
            }
        }
                 
    }
}
